<?php
namespace App\Classes\Helpers;

use App\Classes\General\PublicConstants;
use Illuminate\Support\Facades\File;
class FileHelper
{ public static function FileUpload($File,$FileLocation,$Postfix='',$Disk="public")
    {
        $FileName="";
        if($File)
        {
            $Extension = $File->getClientOriginalExtension();
            $FileName=date("YmdHis").($Postfix?"_".$Postfix:"").".".$Extension;
            $File->storeAs($FileLocation,$FileName,$Disk);
        }
        return $FileName;
    }
    public static function FileUploadWithReplace($newFile,$FileLocation,$oldFileName,$Postfix="",$Disk="public")
    {
        
        if($newFile)
        {
            FileHelper::FileDelete($FileLocation,$oldFileName);
            return FileHelper::FileUpload($newFile,$FileLocation,$Postfix,$Disk);
        }
        return '';
    }
 
    public static function FileLink($ImageLocation,$Image)
    {
        if( $Image)
        {
            return "/storage/$ImageLocation$Image";
        }
        else
        {
            return PublicConstants::DEFAULT_IMAGE_PATH.PublicConstants::DEFAULT_IMAGE;
        }
    }
   
    public static function FileDelete($FilePath,$FileName)
    {
        if($FileName)
        {
            File::delete(storage_path("app\\public\\".$FilePath.$FileName));
        }
    }
}