<?php

namespace App\Http\Controllers;

use App\Classes\General\PublicConstants;
use App\Classes\Helpers\FileHelper;
use App\Models\Banner;
use Illuminate\Http\Request;

class BannerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('Banner.index',  ['Banners'=>Banner::all()]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('Banner.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {        
        $request->validate(Banner::$rules);
        //Store Image
        if ($request->hasFile('imageFile')) {
            $request['image']=FileHelper::FileUpload($request->file('imageFile'), PublicConstants::BANNER_IMAGE_PATH);           
        }
        Banner::create($request->all());
        return redirect(route('Banner.index'))->with('Success','Banner created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Banner $Banner)
    {
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Banner $Banner)
    {
        return view('Banner.edit', compact('Banner'));        
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Banner $Banner)
    {
        $request->validate(Banner::$rules);
         //Store Image
        if ($request->hasFile('imageFile')) {
            $request['image']= FileHelper::FileUploadWithReplace($request->file('imageFile'), PublicConstants::BANNER_IMAGE_PATH,$Banner->image);           
        }
        $Banner->update($request->all());
        return redirect(route('Banner.index'))->with('Success','Banner updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Banner $Banner)
    {
        $Banner->delete();
        // Delete Image if exists
        if ($Banner->image) {
           FileHelper::FileDelete(PublicConstants::BANNER_IMAGE_PATH, $Banner->image);
        }
        return redirect(route('Banner.index'))->with('Message', 'Banner deleted successfully');
    }
    
}
