<?php

namespace App\Http\Controllers;

use App\Classes\General\PublicConstants;
use App\Classes\Helpers\FileHelper;
use App\Models\Blog;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $Blogs = Blog::all();
        return view('Blog.index', compact('Blogs'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('Blog.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate(Blog::rules());
        $request['user_id'] = auth()->id(); 
        if ($request->hasFile('BannerFile')) {
            $request['banner'] = FileHelper::FileUpload($request->file('BannerFile'), PublicConstants::BLOG_IMAGE_PATH);
        }
        $blog = Blog::create($request->all());
        return redirect()->route('Blog.index')->with('Success','Blog created successfully   ');

    }

    /**
     * Display the specified resource.
     */
    public function show(Blog $Blog)
    {
        //return view('Blog.show', compact('Blog'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Blog $Blog)
    {
        return view('Blog.edit', compact('Blog'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Blog $Blog)
    {
        $request->validate(Blog::rules($Blog->id));
        if ($request->hasFile('BannerFile')) {
            $request['banner'] = FileHelper::FileUploadWithReplace($request->file('BannerFile'), PublicConstants::BLOG_IMAGE_PATH,$Blog->banner);
        }
        $Blog->update($request->all());
        return redirect()->route('Blog.index')->with('Success', 'Blog updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Blog $Blog)
    {
        $Blog->delete();
        if($Blog->banner) {
            FileHelper::FileDelete(PublicConstants::BLOG_IMAGE_PATH, $Blog->banner);
        }
        return redirect()->route('Blog.index')->with('Message', 'Blog deleted successfully');
    }
}
