<?php

namespace App\Http\Controllers;

use App\Classes\General\PublicConstants;
use App\Classes\Helpers\FileHelper;
use App\Models\ProductCategory;
use Illuminate\Http\Request;

class ProductCategoryController extends Controller
{
     public function index()
    {
        return view('ProductCategory.index',  ['ProductCategorys'=>ProductCategory::all()]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('ProductCategory.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {        
        $request->validate(ProductCategory::$rules);
        //Store Image
        if ($request->hasFile('imageFile')) {
            $request['image']=FileHelper::FileUpload($request->file('imageFile'), PublicConstants::PRODUCT_CATEGORY_IMAGE_PATH);           
        }
        ProductCategory::create($request->all());
        return redirect(route('ProductCategory.index'))->with('Success','ProductCategory created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(ProductCategory $ProductCategory)
    {
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ProductCategory $ProductCategory)
    {
        return view('ProductCategory.edit', compact('ProductCategory'));        
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ProductCategory $ProductCategory)
    {
        $request->validate(ProductCategory::$rules);
         //Store Image
        if ($request->hasFile('imageFile')) {
            $request['image']= FileHelper::FileUploadWithReplace($request->file('imageFile'), PublicConstants::PRODUCT_CATEGORY_IMAGE_PATH,$ProductCategory->image);           
        }
        $ProductCategory->update($request->all());
        return redirect(route('ProductCategory.index'))->with('Success','ProductCategory updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ProductCategory $ProductCategory)
    {
        $ProductCategory->delete();
        if ($ProductCategory->image) {
           FileHelper::FileDelete(PublicConstants::PRODUCT_CATEGORY_IMAGE_PATH, $ProductCategory->image);
        }
        return redirect(route('ProductCategory.index'))->with('Message', 'ProductCategory deleted successfully');
    }
    public static function Dropdown($ProductCategoryId)
    {
        if($ProductCategoryId)
        {
            $ProductCategory=ProductCategory::find($ProductCategoryId);
            return view('ProductCategory.menu', compact('ProductCategory'));
        }
    }
}
