<?php

namespace App\Models;

use App\Classes\General\PublicConstants;
use App\Classes\Helpers\FileHelper;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class Banner extends Model
{
    protected $fillable = ['title', 'description', 'image', 'button', 'discount_text', 'link'];
    public static $rules = [
        'title' => 'required|string|max:255',
        'description' => 'nullable|string',
        'imageFile' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        'button' => 'nullable|string|max:255',
        'discount_text' => 'nullable|string|max:255',
        'link' => 'nullable|url|max:255'        
    ];

    protected $appends = ['image_url'];
    protected function imageUrl(): Attribute
    {
        return Attribute::make(
            get: fn () =>FileHelper::FileLink(PublicConstants::BANNER_IMAGE_PATH, $this->image)
        );
    } 
   
}
