<?php

namespace App\Models;

use App\Classes\General\PublicConstants;
use App\Classes\Helpers\FileHelper;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class ProductCategory extends Model
{
    protected $fillable = ['title','description', 'image', 'category_id'];
    public static $rules = [
        'title' => 'required|string|max:255',
        'description' => 'nullable|string',
        'imageFile' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        'category_id' => 'required|exists:product_categories,id',
    ];
    protected $appends = ['image_url'];

    public function Children()
    {
        return $this->hasMany(ProductCategory::class,'category_id','id');
    }
    public function Parent()
    {
        return $this->belongsTo(ProductCategory::class, 'category_id');
    }    
    public function Products()
    {
        return $this->hasMany(Product::class,'category_id');
        
    }
    public static function RootCategories()
    {
        return self::whereNot('id', 1)->get();
    }
    protected function imageUrl(): Attribute
    {
        return Attribute::make(
            get: fn () =>FileHelper::FileLink(PublicConstants::PRODUCT_CATEGORY_IMAGE_PATH, $this->image)
        );
    }   
}
