@use('App\Models\BlogCategory')
@extends('layouts.app')
@section('title', 'BlogCategory')
@section('content')
  <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Blog Category</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
    {{-- <div class="btn-group me-2"> <button type="button" class="btn btn-sm btn-outline-secondary">Share</button>
      <button type="button" class="btn btn-sm btn-outline-secondary">Export</button>
    </div>  --}}
    {{-- <button type="button"
      class="btn btn-sm btn-outline-secondary dropdown-toggle d-flex align-items-center gap-1">
      <svg class="bi" aria-hidden="true">
      <use xlink:href="#calendar3"></use>
      </svg>
      This week
    </button> --}}
    <a href="{{ route('BlogCategory.index') }}" class="btn btn-outline-primary ml-2"><i class="bi bi-arrow-left-circle"></i> Back</a>
    </div>
  </div>
    <form action="{{ route('BlogCategory.update',$BlogCategory->id) }}" method="post" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="title" class="form-label">Title</label>
                    <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" value="{{$BlogCategory->title }}" required name="title">
                    @error('title') <span class="invalid-feedback">{{ $message }}</span> @enderror
                </div>               
            </div>                          
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="description" class="form-label">Description</label>
                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{$BlogCategory->description}}</textarea>
                    @error('description') <span class="invalid-feedback">{{ $message }}</span> @enderror
                </div>
            </div>
            <div class="col-md-12">
                <button type="submit" class="btn btn-primary"><i class="bi bi-floppy"></i> Update</button>
                <button type="reset" class="btn btn-secondary"><i class="bi bi-arrow-clockwise"></i> Reset</button>
                {{-- <a href="{{ route('BlogCategory.index') }}" class="btn btn-secondary">Cancel</a> --}}
            </div>
        </div>
    </form>
@endsection