@extends('layouts.app')
@section('title', 'BlogCategory')
@section('content')
  <x-flash />
  <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Blog Category</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
      <div class="btn-group me-2"> 
        <button type="button" class="btn btn-sm btn-outline-secondary">Share</button>
        <button type="button" class="btn btn-sm btn-outline-secondary">Export</button>
      </div>   
      <a href="{{ route('BlogCategory.create') }}" class="btn btn-outline-primary ml-2"><i class="bi bi-plus-circle"></i> Add New</a>
    </div>
  </div>
  
  {{-- <h2>BlogCategorys</h2> --}}
  <div class="table-responsive">
    <table class="table table-striped">
      <thead>
        <tr>
        <th scope="col">#</th>
        <th scope="col">Title</th>
        <th colspan="2">Action</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($BlogCategories as $BlogCategory)    
          <tr>
            <td>{{ $loop->iteration+1 }}</td>
            <td>{{ $BlogCategory->title }}</td>
            <td>
              <a class="btn btn-warning" href="{{ route('BlogCategory.edit', $BlogCategory->id) }}">
                <i class="bi bi-pencil-square"></i> Edit
              </a>
            </td>
            <td>
              <form action="{{ route('BlogCategory.destroy', $BlogCategory->id) }}" method="POST"
                onsubmit="return confirm('Are you sure you want to delete this blogcategory?');">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger"><i class="bi bi-trash"></i> Delete</button>
              </form>
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
@endsection