@use('App\Models\ProductCategory')
@extends('layouts.app')
@section('title', 'Product')
@section('content')
  <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Product</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
    {{-- <div class="btn-group me-2"> <button type="button" class="btn btn-sm btn-outline-secondary">Share</button>
      <button type="button" class="btn btn-sm btn-outline-secondary">Export</button>
    </div>  --}}
    {{-- <button type="button"
      class="btn btn-sm btn-outline-secondary dropdown-toggle d-flex align-items-center gap-1">
      <svg class="bi" aria-hidden="true">
      <use xlink:href="#calendar3"></use>
      </svg>
      This week
    </button> --}}
    <a href="{{ route('Product.index') }}" class="btn btn-outline-primary ml-2"><i class="bi bi-arrow-left-circle"></i> Back</a>
    </div>
  </div>
    <form action="{{ route('Product.update',$Product->id) }}" method="post" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="col-md-6">                
            <label for="title" class="form-label">Title</label>
            <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ $Product->title }}" required>
            @error('title') <span class="invalid-feedback">{{ $message }}</span> @enderror                               
            </div>
            <div class="col-md-6">                
            <label for="Product" class="form-label"><a href="{{ route('ProductCategory.index') }}">Category</a></label>
            <select id="Product" name="category_id" class="form-control @error('category_id') is-invalid @enderror" >
                @foreach (ProductCategory::where('id','!=',1)->get() as $DropdownItem)
                <option value="{{ $DropdownItem->id }}" {{ $Product->category_id == $DropdownItem->id ? 'selected' : '' }}>{{$DropdownItem->title}}</option>
                @endforeach
            </select>                
            @error('category_id') <span class="invalid-feedback">{{ $message }}</span> @enderror                
            </div>
            <div class="col-md-6">                
            <label for="slug" class="form-label">Slug</label>
            <input type="text" class="form-control @error('slug') is-invalid @enderror" id="slug" name="slug" value="{{ $Product->slug }}" required>
            @error('slug') <span class="invalid-feedback">{{ $message }}</span> @enderror                               
            </div>
            <div class="col-md-6">                
            <label for="sub_title" class="form-label">Subtitle</label>
            <input type="text" class="form-control @error('sub_title') is-invalid @enderror" id="sub_title" name="sub_title" value="{{ $Product->sub_title }}" >
            @error('sub_title') <span class="invalid-feedback">{{ $message }}</span> @enderror                               
            </div>
            <div class="col-md-6">                
            <label for="price" class="form-label">Price</label>
            <input type="text" class="form-control @error('price') is-invalid @enderror" id="meta_title" name="price" value="{{ $Product->price }}" >
            @error('price') <span class="invalid-feedback">{{ $message }}</span> @enderror                               
            </div>
            <div class="col-md-6">                
            <label for="original_price" class="form-label">Original Price</label>
            <input type="text" class="form-control @error('original_price') is-invalid @enderror" id="original_price" name="original_price" value="{{ $Product->original_price }}" >
            @error('original_price') <span class="invalid-feedback">{{ $message }}</span> @enderror                               
            </div>
            <div class="col-md-6">                
            <label for="rating" class="form-label">Rating</label>
            <input type="text" class="form-control @error('rating') is-invalid @enderror" id="rating" name="rating" value="{{ $Product->rating }}" required>
            @error('rating') <span class="invalid-feedback">{{ $message }}</span> @enderror                               
            </div>
            <div class="col-md-6">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ $Product->description }}</textarea>
            @error('description') <span class="invalid-feedback">{{ $message }}</span> @enderror                
            </div>
            <div class="col-md-6">
            <label for="about" class="form-label">About</label>
            <textarea class="form-control @error('about') is-invalid @enderror" id="about" name="about" rows="3">{{ $Product->about }}</textarea>
            @error('about') <span class="invalid-feedback">{{ $message }}</span> @enderror                
            </div>
            <div class="col-md-6">
            <label for="quantity" class="form-label">Quantity</label>
            <input type="number" class="form-control @error('quantity') is-invalid @enderror" id="quantity" name="quantity" value="{{ $Product->quantity }}"  min="0">
            @error('quantity') <span class="invalid-feedback">{{ $message }}</span> @enderror
            </div>           
            <div class="col-md-6">    
            <div class="row">
                <div class="col">                        
                <label for="image" class="form-label">Image</label>
                <input type="file" class="form-control @error('image') is-invalid @enderror" id="image" name="imageFile" accept="image/*" onchange="viewImage(event,0)">                        
                @error('image') <span class="invalid-feedback">{{ $message }}</span> @enderror
                </div>
                <div class="col" id="divImageViewer0">
                <button type="button" id="btnRemoveImage0" onclick="RemoveImage(0)" class="btn btn-danger">X</button>
                <img id="imagePreview0" src="{{ $Product->imageUrl }}" alt="Image Preview" class="img-fluid">
                </div>
            </div>
            </div>             
        </div>
        <hr class="my-4">
        <h4>Other Images</h4>
        <div class="row" id="divOtherImages">
          @foreach($Product->ProductImages as $I => $image)
           @php
             $index = $I + 1;
           @endphp
             
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="input-group">
                        <input type="file" class="form-control" name="ProductImages[]" accept="image/*" onchange="viewImage(event, {{ $index }})">
                        <button type="button" class="btn btn-danger" onclick="RemoveImage({{ $index }})">Remove</button>
                    </div>
                </div>
                <div class="col-md-6" id="divImageViewer{{ $index }}" style="{{ $image->image ? '' : 'display:none;' }}">
                    <input type="hidden" name="OldProductImages[]" value="{{ $image->id }}" id="htnProductImage{{ $index }}">
                    <img id="imagePreview{{ $index }}" src="{{ $image->imageUrl }}" alt="Image Preview" class="img-fluid mt-2" style="height: 100px;">
                </div>
            </div>
          @endforeach
        </div>
        <div class="row border border-secondary p-2">
            <div class="col">
                <button type="button" class="btn btn-info" onclick="bntAddImage_Click();"><i class="bi bi-plus"></i> <i
                        class="bi bi-image"></i> Add Image</button>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 mt-2">
                <button type="submit" class="btn btn-primary"><i class="bi bi-floppy"></i> Save</button>
                <button type="reset" class="btn btn-secondary"><i class="bi bi-arrow-clockwise"></i> Reset</button>
            </div>
        </div>
    </form>
     <script>
        function viewImage(event, index) {
            index = index.toString();
            const imageViewer = document.getElementById('divImageViewer' + index);
            const imagePreview = document.getElementById('imagePreview' + index);
            imageViewer.style.display = 'block';
            imagePreview.src = URL.createObjectURL(event.target.files[0]);
        }
        function RemoveImage(index) {
            const imageViewer = document.getElementById('divImageViewer' + index);
            const imagePreview = document.getElementById('imagePreview' + index);
            const imageInput = document.getElementById('image' + index);
            if(index!=0)
                document.getElementById('htnProductImage' + index).remove();
            imageViewer.style.display = 'none';
            imagePreview.src = '#';
            imageInput.value = '';
        }
        //Auto Slug
        function title_onChange() {
            const title = document.getElementById('title').value;
            const slug = document.getElementById('slug');
            slug.value = title.toLowerCase().replace(/ /g, '-').replace(/[^\w-]+/g, '');
        }
        var GlobalImageIndex = 1;
        function bntAddImage_Click() {
            const divOtherImages = document.getElementById('divOtherImages');

            // Create wrapper div for the new image input
            const newImageDiv = document.createElement('div');
            newImageDiv.className = 'row mb-3'; // Adds spacing between entries

            // Create input group column
            const inputCol = document.createElement('div');
            inputCol.className = 'col-md-6';

            const inputGroup = document.createElement('div');
            inputGroup.className = 'input-group';

            const fileInput = document.createElement('input');
            fileInput.type = 'file';
            fileInput.className = 'form-control';
            fileInput.name = 'other_images';
            fileInput.accept = 'image/*';
            fileInput.name='ProductImages[]';
            fileInput.setAttribute('onchange', `viewImage(event, ${GlobalImageIndex})`);

            const removeButton = document.createElement('button');
            removeButton.type = 'button';
            removeButton.className = 'btn btn-danger';
            removeButton.textContent = 'Remove';
            removeButton.onclick = function () {
                newImageDiv.remove();
            };

            inputGroup.appendChild(fileInput);
            inputGroup.appendChild(removeButton);
            inputCol.appendChild(inputGroup);

            // Create image preview column
            const previewCol = document.createElement('div');
            previewCol.className = 'col-md-6';
            previewCol.id = `divImageViewer${GlobalImageIndex}`;
            previewCol.style.display = 'none';

            const previewImg = document.createElement('img');
            previewImg.id = `imagePreview${GlobalImageIndex}`;
            previewImg.src = '#';
            previewImg.alt = 'Image Preview';
            previewImg.className = 'img-fluid mt-2';
            previewImg.style.height = '100px';
            // previewImg.style.display = 'none';

            previewCol.appendChild(previewImg);

            // Append both columns to the wrapper
            newImageDiv.appendChild(inputCol);
            newImageDiv.appendChild(previewCol);

            // Append to the main container
            divOtherImages.appendChild(newImageDiv);

            GlobalImageIndex++;
        }
    </script>
@endsection