@use('App\Http\Controllers\CartController')
<div class="minicart-contain">
    <a href="javascript:void(0)" class="link-to">
        <span class="icon-qty-combine">
            <i class="icon-cart-mini biolife-icon"></i>
            <span class="qty">{{count(CartController::Get())}}</span>
        </span>
        <span class="title">My Cart </span>
        {{-- <span class="sub-total">$0.00</span> --}}
    </a>
    <div class="cart-content">
        <div class="cart-inner">
            <div>
                <ul class="products">
                    @foreach (CartController::Get() as $ProductId=>$CartItem)
                        <li>
                            <div class="minicart-item">
                                <div class="thumb">
                                    <a href="#"><img src="{{ $CartItem['product']?->ImageUrl }}" width="90" height="90"
                                            alt="National Fresh"></a>
                                </div>
                                <div class="left-info">
                                    <div class="product-title"><a href="#" class="product-name">{{ $CartItem['product']?->title }}</a></div>
                                    {{-- <div class="price">
                                        <ins><span class="price-amount"><span class="currencySymbol">£</span>85.00</span></ins>
                                        <del><span class="price-amount"><span class="currencySymbol">£</span>95.00</span></del>
                                    </div> --}}
                                    <div class="qty">
                                        <label for="cart[id{{ $ProductId }}][qty]">Qty:</label>
                                        <input type="number" class="input-qty" style="background: #555" name="cart[id{{ $ProductId }}][qty]"
                                            id="cart[id{{ $ProductId }}][qty]" value="{{ $CartItem["quantity"] }}" disabled
                                             onfocus="BeginChangeCart(this, {{ $ProductId }})"
                                             onchange="ChangedCart(this, {{ $ProductId }});">
                                    </div>
                                </div>
                                <div class="action">
                                    <a href="#" class="edit" onclick="UpdateCart({{ $ProductId }}); return false;"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                                    <a href="#" onclick="RemoveFromCart({{ $ProductId }}); return false;" class="remove"><i class="fa fa-trash-o" aria-hidden="true"></i></a>
                                </div>
                            </div>
                        </li>
                    @endforeach
                </ul>
            </div>                                            
            <p class="btn-control">
                {{-- <a href="#" class="btn view-cart">view cart</a> --}}
                <a href="{{ route('cart.checkout') }}" class="btn">checkout</a>
            </p>
        </div>
    </div>
</div>
<script src="{{ asset('assets/js/cart.js') }}"></script>